<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use ZipArchive;
use File;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class UpdateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function formUpdate()
    {
        if(file_exists("latest-update.zip")){
            $updates = TRUE;
            $changelog = NULL;
        }else{
            $updates = FALSE;
            if(file_exists(base_path().'/CHANGELOG.txt')){
                $changelog = File::get(base_path().'/CHANGELOG.txt');
            }else{
                $changelog = NULL;
            }
        }
        return view('pages.be.update.form-update', compact('updates', 'changelog'));
    }

    public function doUpdate(Request $request)
    {
        try {
            $response = "";
            $responseCode = 200;
            if(file_exists("latest-update.zip")){
                $cek = DB::table('web_version')->first();
                if($cek){
                    $zip = new ZipArchive;
                    $status = $zip->open('latest-update.zip');
                    if($status === TRUE){
                        if($zip->extractTo(base_path('../'))){
                            $zip->close();
                            File::delete('latest-update.zip');
                            $path = base_path("../database/db.sql");
                            $sql = file_get_contents($path);
                            DB::unprepared($sql);
                            File::deleteDirectory("database");
                            $cekLatest = DB::table('web_version')->first();
                            file_put_contents(base_path("/../webapps/.env"), str_replace(env("APP_VER"), $cekLatest->version, file_get_contents(base_path('../webapps/.env')))); //Ganti versi setiap update website
                            $response = "Mengupdate versi website : ".$cekLatest->version;
                            $responseCode = Response::HTTP_OK;

                        }else{
                            $response = "Gagal mengekstrak update atau masalah di SQL!";
                            $responseCode = Response::HTTP_UNPROCESSABLE_ENTITY;
                        }
                    }else{
                        $response = "Gagal membuka update!";
                        $responseCode = Response::HTTP_UNPROCESSABLE_ENTITY;
                    }
                }else{
                    File::delete('latest-update.zip');
                    $response = "Gagal mengupdate versi website, tidak mendukung OTA Update!";
                    $responseCode = Response::HTTP_UNPROCESSABLE_ENTITY;
                }
            }else{
                $response = "Gagal mengupdate versi website, Update tidak tersedia!";
                $responseCode = Response::HTTP_UNPROCESSABLE_ENTITY;
            }
            \Helper::log(\Auth::user()->username, $response);
            Artisan::call('optimize:clear');
            return response()->json(['code' => $responseCode, 'msg' => $response]);
        } catch (\Throwable $e) {
            File::delete('latest-update.zip');
            \Helper::log(\Auth::user()->username, "Sukses mengupdate versi website dengan beberapa catatan : ".$e->getMessage());
            Artisan::call('optimize:clear');
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate system website dengan beberapa catatan, cek Log!']);
        }
    }

    public function doOptimize()
    {
        try {
            Artisan::call('optimize:clear');
            \Helper::log(\Auth::user()->username, "Mengoptimasi website!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengoptimasi website!']);
        } catch (QueryException $e) {
            \Helper::log(\Auth::user()->username, "Gagal mengoptimasi website!");
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => 'Gagal, '.$e->getMessage()]);
        }
    }
}
