<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ValidationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if (request()->isMethod('post')) {
            $rules['file'] = 'file|max:500|file|mimes:jpg,jpeg,png,JPG,JPEG,PNG,pdf,PDF,doc,docx,xls,xlsx,ppt,pptx';
            $rules['foto'] = 'file|max:500|mimes:jpg,jpeg,png,JPG,JPEG,PNG';
            $rules['picture'] = 'file|max:500|mimes:jpg,jpeg,png,JPG,JPEG,PNG';
            $rules['logo'] = 'file|max:500|mimes:jpg,jpeg,png,JPG,JPEG,PNG';
            $rules['struktur'] = 'file|max:500|mimes:jpg,jpeg,png,JPG,JPEG,PNG';
        }
        return $rules;
    }

    public function messages()
    {
        return [
            'file.max'  => 'File melebihi batas Max:500kb!',
            'file.mimes' => 'Hanya File berextensi jpg/pdf/doc/xls/ppt diperbolehkan!',
            'foto.max' => 'Foto melebihi batas Max:500kb!',
            'foto.mimes' => 'Hanya foto berextensi jpg/png yang diperbolehkan!',
            'picture.max' => 'Gambar melebihi batas Max:500kb!',
            'picture.mimes' => 'Hanya Gambar berextensi jpg/png yang diperbolehkan!',
            'logo.max' => 'Logo melebihi batas Max:500kb!',
            'logo.mimes' => 'Hanya Logo berextensi jpg/png yang diperbolehkan!',
            'struktur.max' => 'Stuktur melebihi batas Max:500kb!',
            'struktur.mimes' => 'Hanya Stuktur berextensi jpg/png yang diperbolehkan!'
        ];
    }
}
