@extends('layouts.master')
@section('title', $data->title)
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Blog Detail : {{ $data->title }}</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- Blog page section  -->
<section class="blog-page-section spad pt-0">
	<div class="container">
		<div class="row">
			<div class="col-md-8">
                @if($data->updated_at != NULL)
                    @php
                    $cekCreate = Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $data->created_at, 'Asia/Jakarta')->addMonth(3);
                    $cekUpdate = $data->updated_at;
                    @endphp
                    @if(strtotime($cekUpdate) > strtotime($cekCreate))
                    <div class="post-item post-details">
                        <h3 style="color:red;">Anda memanipulasi data terlalu jauh. Kembalikan tanggal ke semula!</h3>
                    </div>
                    @else
                    <div class="post-item post-details">
                        <img src="<?php if($data->picture != NULL){ echo url('assets/files/blog/'.$data->picture.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>" class="post-thumb-full" alt="">
                        <div class="post-content">
                            <h3><a href="{{ url('blog') }}/{{ $data->slug }}">{{ $data->title }}</a></h3>
                            <div class="post-meta">
                                <span><i class="fa fa-calendar-o"></i> {{ $data->updated_at != NULL ? Helper::tgl_indo($data->updated_at) : Helper::tgl_indo($data->created_at) }}</span>
                                <span><i class="fa fa-user"></i> {{ $data->nama_author }}</span>
                            </div>
                            <p align="justify"><?php echo $data->content; ?></p>
                            <!-- <div class="tag"><i class="fa fa-tag"></i> EDUCATION, MARKETING</div> -->
                        </div>
                        <div class="post-author">
                            <div class="pa-thumb set-bg" data-setbg="<?php if($data->foto_author != NULL){ echo url('assets/files/profile/'.$data->foto_author.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>"></div>
                            <div class="pa-content">
                                <h4>Ditulis oleh :</h4>
                                <p><i class="fa fa-user-o"></i> {{ $data->nama_author }}</p>
                                <p><i class="fa fa-calendar-o"></i> {{ Helper::tgl_indo($data->created_at) }}</p>
                            </div>
                        </div>
                        <!-- <div class="comment-warp">
                            <h4 class="comment-title">3 Comments</h4>
                            <ul class="comment-list">
                                <li>
                                    <div class="comment">
                                        <div class="comment-avator set-bg" data-setbg="img/blog/comment/1.jpg"></div>
                                        <div class="comment-content">
                                            <span class="c-date">24 Mar 2018</span>
                                            <h5>Kelly Richardson</h5>
                                            <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam.</p>
                                            <a href="" class="c-btn">Like</a>
                                            <a href="" class="c-btn">Reply</a>
                                        </div>
                                    </div>
                                    <ul class="replay-comment-list">
                                        <li>
                                            <div class="comment">
                                                <div class="comment-avator set-bg" data-setbg="img/blog/comment/2.jpg"></div>
                                                <div class="comment-content">
                                                    <span class="c-date">24 Mar 2018</span>
                                                    <h5>Gordon Browns</h5>
                                                    <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore.</p>
                                                    <a href="" class="c-btn">Like</a>
                                                    <a href="" class="c-btn">Reply</a>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </li>
                                <li>
                                    <div class="comment">
                                        <div class="comment-avator set-bg" data-setbg="img/blog/comment/3.jpg"></div>
                                        <div class="comment-content">
                                            <span class="c-date">24 Mar 2018</span>
                                            <h5>Scott Langton</h5>
                                            <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam.</p>
                                            <a href="" class="c-btn">Like</a>
                                            <a href="" class="c-btn">Reply</a>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <div class="comment-form-warp">
                                <h4 class="comment-title">Leave Your Comment</h4>
                                <form class="comment-form">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" placeholder="Your Name">
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="email" placeholder="Your Email">
                                        </div>
                                        <div class="col-sm-12">
                                            <textarea placeholder="Your Message"></textarea>
                                            <button class="site-btn">SEND COMMENT</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div> -->
                    </div>
                    @endif
                @else
                <div class="post-item post-details">
                    <img src="<?php if($data->picture != NULL){ echo url('assets/files/blog/'.$data->picture.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>" class="post-thumb-full" alt="">
                    <div class="post-content">
                        <h3><a href="{{ url('blog') }}/{{ $data->slug }}">{{ $data->title }}</a></h3>
                        <div class="post-meta">
                            <span><i class="fa fa-calendar-o"></i> {{ $data->updated_at != NULL ? Helper::tgl_indo($data->updated_at) : Helper::tgl_indo($data->created_at) }}</span>
                            <span><i class="fa fa-user"></i> {{ $data->nama_author }}</span>
                        </div>
                        <p align="justify"><?php echo $data->content; ?></p>
                        <!-- <div class="tag"><i class="fa fa-tag"></i> EDUCATION, MARKETING</div> -->
                    </div>
                    <div class="post-author">
                        <div class="pa-thumb set-bg" data-setbg="<?php if($data->foto_author != NULL){ echo url('assets/files/profile/'.$data->foto_author.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>"></div>
                        <div class="pa-content">
                            <h4>Ditulis oleh :</h4>
                            <p><i class="fa fa-user-o"></i> {{ $data->nama_author }}</p>
                            <p><i class="fa fa-calendar-o"></i> {{ Helper::tgl_indo($data->created_at) }}</p>
                        </div>
                    </div>
                    <!-- <div class="comment-warp">
                        <h4 class="comment-title">3 Comments</h4>
                        <ul class="comment-list">
                            <li>
                                <div class="comment">
                                    <div class="comment-avator set-bg" data-setbg="img/blog/comment/1.jpg"></div>
                                    <div class="comment-content">
                                        <span class="c-date">24 Mar 2018</span>
                                        <h5>Kelly Richardson</h5>
                                        <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam.</p>
                                        <a href="" class="c-btn">Like</a>
                                        <a href="" class="c-btn">Reply</a>
                                    </div>
                                </div>
                                <ul class="replay-comment-list">
                                    <li>
                                        <div class="comment">
                                            <div class="comment-avator set-bg" data-setbg="img/blog/comment/2.jpg"></div>
                                            <div class="comment-content">
                                                <span class="c-date">24 Mar 2018</span>
                                                <h5>Gordon Browns</h5>
                                                <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore.</p>
                                                <a href="" class="c-btn">Like</a>
                                                <a href="" class="c-btn">Reply</a>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <div class="comment">
                                    <div class="comment-avator set-bg" data-setbg="img/blog/comment/3.jpg"></div>
                                    <div class="comment-content">
                                        <span class="c-date">24 Mar 2018</span>
                                        <h5>Scott Langton</h5>
                                        <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam.</p>
                                        <a href="" class="c-btn">Like</a>
                                        <a href="" class="c-btn">Reply</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                        <div class="comment-form-warp">
                            <h4 class="comment-title">Leave Your Comment</h4>
                            <form class="comment-form">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input type="text" placeholder="Your Name">
                                    </div>
                                    <div class="col-sm-6">
                                        <input type="email" placeholder="Your Email">
                                    </div>
                                    <div class="col-sm-12">
                                        <textarea placeholder="Your Message"></textarea>
                                        <button class="site-btn">SEND COMMENT</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div> -->
                </div>
                @endif
			</div>
			<!-- sidebar -->
			@include('layouts.sidebar')
		</div>
	</div>
</section>
<!-- Blog page section end -->

@endsection
