<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Permissions-Policy" content="interest-cohort=()">
    <title>Install Website</title>
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/icon" href="data:image/png;base64,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"/>
    <link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,500i,700,700i,900" rel="stylesheet">
    <link href="assets/css/font-awesome.min.css" rel="stylesheet"> 
    <link href="assets/css/bootstrap-grid.css" rel="stylesheet">
    <link href="assets/css/multistep.min.css" rel="stylesheet">
    <link href="assets/css/animate.css" rel="stylesheet">
    <link href="assets/css/main.css" rel="stylesheet">
</head>

<body>
    <div class="loader"></div>
    <!--Multi Step Wizard Start-->
    <div id="rms-wizard" class="rms-wizard">
        <!--Wizard Container-->
        <div class="rms-container">
            <!--Wizard Header-->
            <div class="rms-wizard-header">
                <h2 class="title">Setup Website <span>Selesai</span></h2>
            </div>
            <!--Wizard Header Close--> 
            <div class="rms-form-wizard">
                <!--Wizard Step Navigation Start-->
                <div class="rms-step-section" data-step-counter="false" data-step-image="false">
                    <?php 
                    set_time_limit(0);
                    ini_set('memory_limit', '256M');
                    function copy_directory($source, $destination ) { 
                        if ( is_dir( $source ) ) { 
                            @mkdir( $destination ); 
                            $directory = dir( $source ); 
                            while ( FALSE !== ( $readdirectory = $directory->read() ) ) { 
                                if ( $readdirectory == '.' || $readdirectory == '..' ) { 
                                    continue; 
                                } 
                                $PathDir = $source . '/' . $readdirectory; 
                                if ( is_dir( $PathDir ) ) { 
                                    copy_directory( $PathDir, $destination . '/' . $readdirectory ); 
                                    continue; 
                                } 
                                copy( $PathDir, $destination . '/' . $readdirectory ); 
                            }
                            $directory->close(); 
                        }else { 
                            copy( $source, $destination ); 
                        } 
                    }
                    if (isset($_POST['name'])) {
                        $servername = $_POST["database_host"]; 
                        $username = $_POST["database_user"];
                        $password = $_POST["database_password"]; 
                        $dbname = $_POST["database_name"]; 

                        $cek =  mysqli_connect($servername, $username, $password, $dbname);
                        $opt = array(PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT);
                        if($cek == true){
                            $con = new PDO("mysql:host=" . $_POST["database_host"] . ";dbname=" . $_POST["database_name"] . ";charset=utf8mb4", $_POST["database_user"], $_POST["database_password"], $opt) ;

                            copy_directory("project/webapps","../webapps");
                            copy_directory("project/public_html","../");
                            copy_directory("database","db");

                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{host}}",$_POST["database_host"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{user}}",$_POST["database_user"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{name}}",$_POST["database_name"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{port}}",$_POST["database_port"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{password}}",$_POST["database_password"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{nama_website}}",$_POST["nama_website"], file_get_contents('../webapps/.env')));
                            file_put_contents(__DIR__ . "/../webapps/.env", str_replace("{{web_version}}","25.3.1", file_get_contents('../webapps/.env')));


                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{admin_name}}",$_POST["name"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{admin_password}}",password_hash($_POST["password"], PASSWORD_DEFAULT), file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{admin_email}}",$_POST["sekolah_email"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{admin_username}}",$_POST["username"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{nama_website}}",$_POST["nama_website"], file_get_contents('db/db.sql')));               

                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_nama}}",$_POST["sekolah_nama"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_email}}",$_POST["sekolah_email"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_npsn}}",$_POST["sekolah_npsn"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_id}}",$_POST["sekolah_id"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{bentuk_pendidikan_id}}",$_POST["bentuk_pendidikan_id"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_alamat}}",$_POST["sekolah_alamat"], file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{sekolah_telepon}}",$_POST["sekolah_telepon"], file_get_contents('db/db.sql')));


                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{web_version}}","25.3.1", file_get_contents('db/db.sql')));
                            file_put_contents(__DIR__ . "/db/db.sql", str_replace("{{current_date}}",date('Y-m-d H:i:s'), file_get_contents('db/db.sql')));

                            $file_sql    = file_get_contents(__DIR__ . '/db/db.sql');
                            file_put_contents(__DIR__."/db/db.sql", $file_sql);

                            //getBackup
                            $npsn = $_POST["sekolah_npsn"];
                            $content = file_get_contents("http://192.168.19.242/whm-backup/".$npsn.".zip");
                            $storeBackup = file_put_contents($npsn.".zip", $content);                               
                            if($storeBackup){
                                $dir ="./";
                                $open =opendir($dir) or die('Folder tidak ditemukan ...!');
                                while ($file    =readdir($open)) {
                                    if($file !='.' && $file !='..'){
                                        $fileName = $file;

                                    }
                                }

                                if (isset($fileName)) {
                                    $zip = new ZipArchive;
                                    $res = $zip->open($fileName);
                                    if ($res === TRUE) {
                                        $zip->extractTo('../');
                                        $zip->close();
                                    }
                                }
                            }
                            try{
                                $con->exec($file_sql); 
                                ?>
                                <center>
                                    <h1>Install Sukses, silahkan hapus folder <b class="alert">  install</b> pada directory public_html</h1>
                                    <h1><?=$_POST["nama_website"]?></h1>
                                    <form enctype="multipart/form-data" method="GET" action="/remove-installer">
                                        <button type="submit">Akses Website </button>
                                    </form>
                                </center>
                                <?php
                            } catch(PDOException $e) {
                                ?>
                                <center>
                                    <h1>Install Sukses dengan catatan : <?php echo $e->getMessage(); ?>, silahkan hapus folder <b class="alert">  install</b> pada directory public_html</h1>
                                    <h1><?=$_POST["nama_website"]?></h1>
                                    <form enctype="multipart/form-data" method="GET" action="/remove-installer">
                                        <button type="submit">Akses Website </button>
                                    </form>
                                </center>
                                <?php
                            }
                        } else { 
                            $url = isset($_SERVER['HTTP_REFERER']) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : ''; 
                            ?>
                            <center>
                            <h1>Install Gagal, Silahkan cek kembali configurasi informasi server!!! </h1>
                                <button id="restartInstall">klik Kembali</button> 
                            </center>
                            <?php
                        }
                    } else { 
                        $url = isset($_SERVER['HTTP_REFERER']) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : ''; 
                        ?>
                        <center>
                        <h1>Install Gagal, Konfirgurasi tidak ditemukan. Silahkan ulangi proses dari awal!</h1>
                        <button id="restartInstall">klik Kembali</button> 
                        </center>
                        <?php
                    }
                    ?>

                </div>
                <!--Wizard Content Section Close-->
            </div>
        </div>
        <!--Wizard Container Close-->
    </div>
    <?php
    function rrmdir($dir) { 
        if (is_dir($dir)) { 
            $objects = scandir($dir);
            foreach ($objects as $object) { 
            if ($object != "." && $object != "..") { 
                if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object))
                rrmdir($dir. DIRECTORY_SEPARATOR .$object);
                else
                unlink($dir. DIRECTORY_SEPARATOR .$object); 
            } 
            }
            rmdir($dir);
            exec('cd ../webapps && php artisan optimize:clear');
        } 
    }
    ?>
    <!--Multi Step Wizard Close-->
    <!-- jQuery 3 -->
    <script src="assets/js/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="assets/js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="assets/js/multistep.min.js"></script>
    <script type="text/javascript" src="assets/js/main.js"></script>
</body>
</html>