<?php

namespace App\Http\Controllers\Api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DataHosting;
use App\Http\Resources\DomainCollection;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;

class DataHostingController extends Controller
{
    //List Domain
    public function getDomain()
    {
        try {
            $domains = DataHosting::orderBy('kecamatan', 'ASC')->orderBy('nama_sekolah', 'ASC')->get();
            $data = new DomainCollection($domains);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'status' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }
}
