<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProfileSekolahItem extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'nama_sekolah' => $this->nama_sekolah,
            'deskripsi_sekolah' => $this->deskripsi_sekolah,
            'logo' => $this->logo != NULL ? url('assets/files/logo/'.$this->logo.'?time='.time()) : NULL,
            'media' => [
                'facebook' => $this->facebook,
                'twitter' => $this->twitter,
                'instagram' => $this->instagram,
            ],
            'tautan' => [
                'nama_tautan1' => $this->nama_tautan_1,
                'nama_tautan2' => $this->nama_tautan_2,
                'nama_tautan3' => $this->nama_tautan_3,
                'tautan1' => $this->tautan_1,
                'tautan2' => $this->tautan_2,
                'tautan3' => $this->tautan_3,
            ],
            'kontak' => [
                'telepon' => $this->telepon_sekolah,
                'website' => url('/'),
                'email' => $this->email_sekolah,
                'alamat' => $this->alamat_sekolah,
            ],
            'web_version' => $this->web_version,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
