@extends('layouts.app')
@section('title', 'Profile')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    User Profile
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="#">Examples</a></li>
    <li class="active">User profile</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">

  <div class="row">
    <div class="col-md-3">

      <!-- Profile Image -->
      <div class="box box-primary">
        <div class="box-body box-profile">
          <img class="profile-user-img img-responsive img-circle" src="@if($model->foto == null) {{ url('assets/frontend/img/no-picture.png') }} @else {{ url('assets/files/profile') }}/{{ $model->foto }} @endif" alt="User profile picture">

          <h3 class="profile-username text-center">{{$model->name}}</h3>

          <p class="text-muted text-center">Member since: {{ date('M. Y', strtotime($model->created_at)) }}</p>

          <ul class="list-group list-group-unbordered">
            <li class="list-group-item">
              <b>Nama</b> <a class="pull-right">{{$model->name}}</a>
            </li>
            <li class="list-group-item">
              <b>Email</b> <a class="pull-right">{{$model->email}}</a>
            </li>
          </ul>

          <a href="{{route('profile.edit', $model->id)}}" class="btn btn-primary btn-block modal-show edit" title="Set Profile: {{$model->username}}"><b>Setting</b></a>
          <a href="{{route('profile.resetToken', $model->id)}}" class="btn btn-warning btn-block resetToken" title="Set Profile: {{$model->username}}"><b>Reset Token</b></a>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
    <!-- /.col -->
    <div class="col-md-9">
      <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
          <li class="active"><a href="#kegiatan" data-toggle="tab">Kegiatan</a></li>
          <li><a href="#blog" data-toggle="tab">Blog</a></li>
        </ul>
        <div class="tab-content">
          <div class="active tab-pane" id="kegiatan">
            <!-- Post -->
            <div class="box-body">
              <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
                <ol class="carousel-indicators">
                  <?php
                  $jmlSlide = $kegiatan->count();
                  for($i=0;$i<=$jmlSlide;$i++){
                  ?>
                  <li data-target="#carousel-example-generic" data-slide-to="{{$i}}" class="<?php if($i==1){ echo 'active'; } ?>"></li>
                  <?php } ?>
                </ol>
                <div class="carousel-inner">
                  <?php $no=0;
                  foreach($kegiatan as $row): $no++; ?>
                  <div class="item <?php if($no==1){ echo 'active'; } ?>">
                    <img src="<?php if($row->picture != NULL){ echo url('assets/files/kegiatan').'/'.$row->picture; }else{ echo url('assets/frontend/img/no-picture.png'); } ?>" alt="First slide">

                    <div class="carousel-caption">
                      {{$row->title}}
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
                <a class="left carousel-control" href="#carousel-example-generic" data-slide="prev">
                  <span class="fa fa-angle-left"></span>
                </a>
                <a class="right carousel-control" href="#carousel-example-generic" data-slide="next">
                  <span class="fa fa-angle-right"></span>
                </a>
              </div>
            </div>
            <!-- /.box-body -->
            <!-- /.post -->
          </div>
          <!-- /.tab-pane -->
          <div class="tab-pane" id="blog">
            <!-- Post -->
            @foreach($blog as $row)
            <div class="post">
              <div class="user-block">
                <img class="img-circle img-bordered-sm" src="<?php if($row->foto_author != NULL){ echo url('assets/files/profile').'/'.$row->foto_author; }else{ echo url('assets/frontend/img/no-picture.png'); } ?>" alt="user image">
                    <span class="username">
                      <a href="#">{{ $row->nama_author }}</a>
                    </span>
                <span class="description">{{ \Helper::tgl_indo($row->created_at) }}</span>
              </div>
              <!-- /.user-block -->
              <h4><a href="{{ url('blog')}}/{{ $row->slug }}" target="_blank">{{ $row->title }}</a></h4>
              <p>{{ substr($row->content, 0, 100) }}... <a href="{{ url('blog')}}/{{ $row->slug }}" target="_blank">Read more</a></p>
            </div>
            @endforeach
            <!-- /.post -->
          </div>
          <!-- /.tab-pane -->
        </div>
        <!-- /.tab-content -->
      </div>
      <!-- /.nav-tabs-custom -->
    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->

</section>
<!-- /.content -->

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
    $('body').on('click', '.modal-show', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').removeClass('hide').text(me.hasClass('edit') ? 'Ubah' : 'Simpan');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '.btn-komentar', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').removeClass('hide').text('Simpan');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '.btn-show', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').addClass('hide');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '#modal-btn-save', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        var form = $('#formProfile'),
            url = form.attr('action'),
            method = $('input[name=_method]').val() == undefined ? 'POST' : 'PUT';

        form.find('.help-block').remove();
        form.find('.form-group').removeClass('has-error');
        $.ajax({
        url: url,
        method: method,
        dataType: "JSON",
        data: form.serialize(),
        success: function(response){
            timeout = setTimeout(loaded, 1000);
            if(response.code === 200){
                form.trigger('reset');
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();

                swal({
                    type: 'success',
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.msg,
                });
            }else{
                swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.msg,
                });
            }
        },
        error: function(xhr){
            timeout = setTimeout(loaded, 1000);
            var res = xhr.responseJSON;
            if($.isEmptyObject(res) == false) {
            $.each(res.errors, function (key, value) {
                $('#' + key)
                    .closest('.form-group')
                    .addClass('has-error')
                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
            });
            }
        }
        });
    });

    $('body').on('change', '.uploadfoto', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        var username = $(this).attr('data-username');
        var fileSelect = document.getElementById($(this).attr('id'));
        var token = $('#_token').val();
        var files = fileSelect.files[0];
        var formData = new FormData();
        formData.append('foto', files);
        formData.append('username', username);
        formData.append('_token', token);
        $.ajax({
            url: "{{route('profile.update_foto')}}",
            method: "POST",
            dataType: "JSON",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    $('#modal').modal('hide');
                    swal({
                        type: 'success',
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    }).then(function(){
                        window.location = '{{url("admin/profile")}}';
                    });
                }else{
                    swal({
                        type: 'error',
                        icon: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    })
                }
            },
            error: function(xhr, status, error){
                timeout = setTimeout(loaded, 1000);
                $('#modal').modal('hide');
                data = JSON.parse(xhr.responseText);
                $.each(data, function(key, item){
                    swal({
                        type: 'error',
                        icon: 'error',
                        title: 'Gagal!',
                        text: 'Gagal upload foto, '+item.foto+'!'
                    });
                });
            }
        })
    });

    $('body').on('click', '.resetToken', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin untuk reset semua token pada akun ini ?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, lanjutkan!'
            ],
            dangerMode: true,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $('.preloader').fadeIn();
                clearTimeout(timeout);
                $.ajax({
                    url: url,
                    method: "GET",
                    dataType: "JSON",
                    success: function(response){
                        timeout = setTimeout(loaded, 1000);
                        if(response.code === 200){
                            $('#datatables').DataTable().ajax.reload();
                            swal({
                                type: 'success',
                                icon: 'success',
                                title: 'Berhasil!',
                                text: response.msg,
                            });
                        }else{
                            swal({
                                type: 'error',
                                icon: 'error',
                                title: 'Gagal!',
                                text: response.msg,
                            });
                        }
                    },
                    error: function(xhr){
                        timeout = setTimeout(loaded, 1000);
                        $('#modal').modal('hide');
                        $('#datatables').DataTable().ajax.reload();
                        swal({
                            type: 'error',
                            icon: 'error',
                            title: 'Gagal!',
                            text: xhr.statusText,
                        });
                    }
                });
            }else{
                swal({
                    type: 'warning',
                    icon: 'warning',
                    title: 'Batal!',
                    text: "Proses dibatalkan!",
                });
            }
        });
    });
});
</script>
@endpush
